import threading
import requests
import random
import os
from pystyle import Colors, Colorate
from queue import Queue
from multiprocessing import Value

os.system("title  [Proxy Scaper + Gen + Checker] - made by the_femboy.dev")

def banner():
    os.system("cls" if os.name == "nt" else "clear")
    print(Colorate.Horizontal(Colors.red_to_blue, f"""
                              
                ██████╗ ██╗   ██╗███████╗███████╗███╗   ██╗    ██████╗ ██████╗  ██████╗ ██╗  ██╗██╗   ██╗
                ██╔══██╗╚██╗ ██╔╝╚══███╔╝██╔════╝████╗  ██║    ██╔══██╗██╔══██╗██╔═══██╗╚██╗██╔╝╚██╗ ██╔╝
                ██████╔╝ ╚████╔╝   ███╔╝ █████╗  ██╔██╗ ██║    ██████╔╝██████╔╝██║   ██║ ╚███╔╝  ╚████╔╝ 
                ██╔═══╝   ╚██╔╝   ███╔╝  ██╔══╝  ██║╚██╗██║    ██╔═══╝ ██╔══██╗██║   ██║ ██╔██╗   ╚██╔╝  
                ██║        ██║   ███████╗███████╗██║ ╚████║    ██║     ██║  ██║╚██████╔╝██╔╝ ██╗   ██║   
                ╚═╝        ╚═╝   ╚══════╝╚══════╝╚═╝  ╚═══╝    ╚═╝     ╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝   ╚═╝   

                              
                                            ╔═════════════════════════════════╗
                                            ║  Made by: the_femboy.dev        ║
                                            ║  Discord: discord.gg/m6FUx2sXXc ║
                                            ╚═════════════════════════════════╝
"""))

def generate_socks5_proxy():
    return f"{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}.{random.randint(1, 255)}:{random.randint(8000, 9000)}"

def scrape_socks5_proxies():
    urls = [
        "https://raw.githubusercontent.com/TheSpeedX/PROXY-List/master/socks5.txt",
        "https://www.proxyscan.io/download?type=socks5",
        "https://raw.githubusercontent.com/hookzof/socks5_list/master/proxy.txt",
        "https://www.proxy-list.download/api/v1/get?type=socks5",
        "https://openproxy.space/list/socks5",
        "https://raw.githubusercontent.com/ShiftyTR/Proxy-List/master/socks5.txt",
        "https://raw.githubusercontent.com/jetkai/proxy-list/main/online-proxies/txt/proxies-socks5.txt",
        "https://raw.githubusercontent.com/mmpx12/proxy-list/master/socks5.txt",
        "https://raw.githubusercontent.com/roosterkid/openproxylist/main/SOCKS5.txt",
        "https://raw.githubusercontent.com/saschazesiger/Free-Proxies/master/proxies/socks5.txt",
        "https://spys.me/socks.txt",
        "https://www.socks-proxy.net/",
        "https://api.proxyscrape.com/v2/?request=displayproxies&protocol=socks5&timeout=10000&country=all",
        "https://proxyspace.pro/socks5.txt",
        "https://raw.githubusercontent.com/ALIILAPRO/Proxy/main/socks5.txt",
        "https://openproxylist.xyz/socks5.txt",
        "https://raw.githubusercontent.com/TheSpeedX/PROXY-List/master/socks5.txt",
        "https://raw.githubusercontent.com/hookzof/socks5_list/master/proxy.txt",
        "https://raw.githubusercontent.com/monosans/proxy-list/main/proxies/socks5.txt",
        "https://raw.githubusercontent.com/mmpx12/proxy-list/master/socks5.txt",
        "https://api.proxyscrape.com/v2/?request=displayproxies&protocol=socks5",
        "https://raw.githubusercontent.com/MuRongPIG/Proxy-Master/main/socks5.txt",
        "https://raw.githubusercontent.com/ShiftyTR/Proxy-List/master/socks5.txt",
        "https://raw.githubusercontent.com/roosterkid/openproxylist/main/SOCKS5_RAW.txt",
        "https://raw.githubusercontent.com/prxchk/proxy-list/main/socks5.txt",
        "https://raw.githubusercontent.com/ALIILAPRO/Proxy/main/socks5.txt",
        "https://www.my-proxy.com/free-socks-5-proxy.html"
    ]
    scraped_proxies = set()
    for url in urls:
        try:
            response = requests.get(url, timeout=5)
            for line in response.text.split('\n'):
                if ':' in line:
                    scraped_proxies.add(line.strip())
        except requests.RequestException:
            continue
    return list(scraped_proxies)

def is_valid_proxy(proxy):
    parts = proxy.split(':')
    if len(parts) != 2:
        return False
    ip, port = parts
    ip_parts = ip.split('.')
    if len(ip_parts) != 4:
        return False
    for part in ip_parts:
        if not part.isdigit() or not (0 <= int(part) <= 255):
            return False
    if not port.isdigit() or not (0 <= int(port) <= 65535):
        return False
    return True

def check_socks5_proxy(proxy, valid_proxies, counter, all_checked_proxies):
    if not is_valid_proxy(proxy):
        return

    test_urls = [
        "https://api64.ipify.org?format=json",
        "https://checkip.amazonaws.com/",
        "https://ifconfig.me",
        "https://icanhazip.com/"
    ]

    for url in test_urls:
        with all_checked_proxies.get_lock():
            all_checked_proxies.value += 1
        try:
            proxies = {"http": f"socks5://{proxy}", "https": f"socks5://{proxy}"}
            response = requests.get(url, proxies=proxies, timeout=3)
            if response.status_code == 200:
                print(Colors.green, f"[VALID] {proxy}")
                valid_proxies.append(proxy)
                with counter.get_lock():
                    counter.value += 1
                return
        except requests.RequestException:
            continue

def save_valid_socks5_proxies(valid_proxies):
    os.makedirs("data", exist_ok=True)
    
    existing_proxies = set()
    if os.path.exists("data/valid_proxies.txt"):
        with open("data/valid_proxies.txt", "r") as file:
            existing_proxies = set(file.read().splitlines())

    new_proxies = set(valid_proxies) - existing_proxies

    with open("data/valid_proxies.txt", "a") as file:
        for proxy in new_proxies:
            file.write(proxy + "\n")

def worker(queue, valid_proxies, counter, all_checked_proxies):
    while not queue.empty():
        proxy = queue.get()
        check_socks5_proxy(proxy, valid_proxies, counter, all_checked_proxies)
        queue.task_done()

def main():
    banner()
    print(Colorate.Horizontal(Colors.blue_to_red, "╔══<s-scrape>═══<g-gen>"))
    print(Colorate.Horizontal(Colors.blue_to_red, "╚═══>>>"), end="")
    choice = input("")
    if choice == "s":
        print(Colorate.Horizontal(Colors.blue_to_red, "Scraping proxies..."))
        print(Colorate.Horizontal(Colors.blue_to_red, "This may take a while..."))
        proxies = scrape_socks5_proxies()
        print(Colorate.Horizontal(Colors.blue_to_red, f"Scraped proxies: {len(proxies)}"))
    elif choice == "g":
        print(Colorate.Horizontal(Colors.blue_to_red, "Enter amount of proxies to generate: "), end="")
        amount = int(input(""))
        if amount > 1:
            print(Colorate.Horizontal(Colors.blue_to_red, "Generating proxies..."))
            proxies = [generate_socks5_proxy() for _ in range(amount)]
        else:
            print(Colors.red + "Invalid input")
            return
    else:
        print(Colors.red + "Invalid choice")
        return

    banner()
    print(Colorate.Horizontal(Colors.blue_to_red, "Enter number of threads"))
    print(Colorate.Horizontal(Colors.blue_to_red, "more threads = faster checking, but max is 100k"))
    print(Colorate.Horizontal(Colors.blue_to_red, ">>> "), end="")
    num_threads = int(input(""))
    if num_threads < 1:
        print(Colors.red + "Invalid number of threads")
        return
    elif num_threads > 100000:
        print(Colors.red + "Too many threads")
        print(Colors.red + "Please enter a number between 1 and 100000")
        return

    proxy_queue = Queue()
    valid_proxies = []
    counter = Value('i', 0)
    all_checked_proxies = Value('i', 0)

    for proxy in proxies:
        proxy_queue.put(proxy)

    threads = []
    for _ in range(num_threads):
        thread = threading.Thread(target=worker, args=(proxy_queue, valid_proxies, counter, all_checked_proxies))
        thread.start()
        threads.append(thread)

    for thread in threads:
        thread.join()

    save_valid_socks5_proxies(valid_proxies)
    print("")
    print(Colorate.Horizontal(Colors.red_to_blue, "Saved valid proxies to data/valid_proxies.txt"))
    print(Colorate.Horizontal(Colors.red_to_blue, f"Total valid proxies: {counter.value}"))
    print(Colorate.Horizontal(Colors.red_to_blue, f"Total checked proxies: {all_checked_proxies.value}"))
    print(Colorate.Horizontal(Colors.red_to_blue, "Press any key to exit..."))
    input()

if __name__ == "__main__":
    main()
